//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "PPSaverDemo_.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "Ppsaver"
#pragma resource "*.dfm"
TForm1 *Form1;

const char* CLSID_MP3AudioDecoder = "{38BE3000-DBF4-11D0-860E-00A024CFEF6D}";
const char* CLSID_DVVideoEncoder = "{13AA3650-BB6F-11D0-AFB9-00AA00B67A42}";
const char* CLSID_AVIMux = "{E2510970-F137-11CE-8B67-00AA00A3F1A6}";

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormCreate(TObject *Sender)
{
   edtRegistryStorage->Text = PropertyPageSaver->RegistryKey;
   rdgRegistryRoot->ItemIndex = PropertyPageSaver->RegistryRoot;

}
//---------------------------------------------------------------------------

void __fastcall TForm1::rdgRegistryRootClick(TObject *Sender)
{
   PropertyPageSaver->RegistryRoot = (TRegistryRoot) rdgRegistryRoot->ItemIndex;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::edtRegistryStorageChange(TObject *Sender)
{
   PropertyPageSaver->RegistryKey = edtRegistryStorage->Text;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::UseOleCreatePropertyFrame (IUnknown *pUnk)
{
   ISpecifyPropertyPages * pPropertyPages;
   CAUUID caGUID;

   if (pUnk) {
      if (pUnk->QueryInterface(IID_ISpecifyPropertyPages, (void **)&pPropertyPages) == S_OK) {
         if (pPropertyPages->GetPages(&caGUID) == S_OK) {
            if (caGUID.cElems > 0) {
               OleCreatePropertyFrame(NULL, 30, 30, L"Properties", 1, &pUnk, caGUID.cElems, caGUID.pElems, NULL, 0, NULL);

            }
            CoTaskMemFree(caGUID.pElems);
         }
         pPropertyPages->Release();
      }
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::UsePropertyPageSaver (IUnknown *pUnk)
{
   if (PropertyPageSaver->Activate (pUnk)) {   // if the dialog has been sucessfully activated
      PropertyPageSaver->RestoreProperties();  // we restore the previous values
      if (PropertyPageSaver->ShowDialog()) {   // we show the dialog
         PropertyPageSaver->SaveProperties();  // we save the new values
      }
      PropertyPageSaver->Deactivate();         // and finally we deactivate the dialog
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DoPropertyPages (GUID CLSID)
{
   IUnknown *pUnk;

   if (CoCreateInstance(CLSID, NULL, CLSCTX_INPROC_SERVER || CLSCTX_LOCAL_SERVER, IID_IUnknown, (void **) &pUnk) == S_OK ) {
      if (rdgUsePPSaver->ItemIndex == 0) { // TPropertyPageSaver saves and restore properties
         UsePropertyPageSaver (pUnk);
      }
      else {
         UseOleCreatePropertyFrame (pUnk);
      }
      pUnk->Release();
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnDVEncoderClick(TObject *Sender)
{
   PropertyPageSaver->DialogTitle = "DV Video encoder properties";
   PropertyPageSaver->RegistrySubKey = "DV Video encoder 0" + IntToStr (rdgSetOfValues->ItemIndex + 1);
   PropertyPageSaver->SelectPages = "";

   // if "Call to undefined function StringToGUID" error, simply recompile the project
   DoPropertyPages (StringToGUID (CLSID_DVVideoEncoder));
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnAVIMuxClick(TObject *Sender)
{
   PropertyPageSaver->DialogTitle = "AVI Mux properties";
   PropertyPageSaver->RegistrySubKey = "AVI Mux 0" + IntToStr (rdgSetOfValues->ItemIndex + 1);
   PropertyPageSaver->SelectPages = "";
   DoPropertyPages (StringToGUID (CLSID_AVIMux));
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnMp3aClick(TObject *Sender)
{
   PropertyPageSaver->DialogTitle = "MPEG-Layer3 audio decoder properties";
   PropertyPageSaver->RegistrySubKey = "";
   PropertyPageSaver->SelectPages = "3,2,1";
   DoPropertyPages (StringToGUID (CLSID_MP3AudioDecoder));
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnMp3bClick(TObject *Sender)
{
   PropertyPageSaver->DialogTitle = "MPEG-Layer3 audio decoder properties";
   PropertyPageSaver->RegistrySubKey = "DV Splitter 0" + IntToStr (rdgSetOfValues->ItemIndex + 1);
   PropertyPageSaver->SelectPages = "3";
   DoPropertyPages (StringToGUID (CLSID_MP3AudioDecoder));
}
//---------------------------------------------------------------------------

void __fastcall TForm1::rdgUsePPSaverClick(TObject *Sender)
{
   bool PPSaverEnabled;

   PPSaverEnabled = rdgUsePPSaver->ItemIndex == 0; // other options disabled if TPropertyPageSaver not used
   rdgSetOfValues->Enabled = PPSaverEnabled;
   rdgRegistryRoot->Enabled = PPSaverEnabled;
   edtRegistryStorage->Enabled = PPSaverEnabled;
   StatusBar1->SimpleText = "";
}
//---------------------------------------------------------------------------

void __fastcall TForm1::rdgSetOfValuesClick(TObject *Sender)
{
   StatusBar1->SimpleText = "You can create several sets of values for each interface->";
}
//---------------------------------------------------------------------------

void __fastcall TForm1::PropertyPageSaverPropertiesRestored(
      TObject *Sender)
{
   StatusBar1->SimpleText = "Properties restored from: " + PropertyPageSaver->GetFullRegistryPath();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::PropertyPageSaverPropertiesSaved(TObject *Sender)
{
   StatusBar1->SimpleText = "Properties saved at: " + PropertyPageSaver->GetFullRegistryPath();
}
//---------------------------------------------------------------------------

